import os, random
from pyenergyplus.plugin import EnergyPlusPlugin
from pyenergyplus.api import EnergyPlusAPI
from PerformanceCurve import Curve_HPDM_IDMAP, Curve_HPDM_ODMAP
import time 
##############################################################################################

class SetEPAPI():
    def setEPapi(self, EP_api : EnergyPlusAPI):
        self.api = EP_api #replace API with master EnergyPlusAPI  
    

class HVACInterface(EnergyPlusPlugin, SetEPAPI):
    def __init__(self):
        super().__init__()
        self.need_to_get_handles = True
        self.IniObjects()
        
        #print ("Hey outside hpdm path check: ", os.getcwd())
        #time.sleep(500)
        return None
    
# customerized codes below #################################################
    def IniObjects(self):
        # self.zone_list =['Core_bottom ZN' ,        
                        # 'Core_mid ZN' ,           
                        # 'Core_top ZN'  ,          
                        # 'Perimeter_bot_ZN_1 ZN' ,
                        # 'Perimeter_bot_ZN_2 ZN'  ,
                        # 'Perimeter_bot_ZN_3 ZN'  ,
                        # 'Perimeter_bot_ZN_4 ZN'  , 
                        # 'Perimeter_mid_ZN_1 ZN'  ,
                        # 'Perimeter_mid_ZN_2 ZN'  ,
                        # 'Perimeter_mid_ZN_3 ZN' , 
                        # 'Perimeter_mid_ZN_4 ZN' , 
                        # 'Perimeter_top_ZN_1 ZN'  , 
                        # 'Perimeter_top_ZN_2 ZN'  ,
                        # 'Perimeter_top_ZN_3 ZN' ,
                        # 'Perimeter_top_ZN_4 ZN' ]
        #self.VRF_IDs = [Curve_HPDM_IDMAP(), Curve_HPDM_IDMAP(),Curve_HPDM_IDMAP(), Curve_HPDM_IDMAP(), Curve_HPDM_IDMAP()]
        self.VRF_ID_Map = Curve_HPDM_IDMAP()
        self.VRF_OD_Map = Curve_HPDM_ODMAP()
        self.RatedCaps:float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.RatedCaps[0] = 6075.048 * 3.412
        self.RatedCaps[1] = 6095.047 * 3.412
        self.RatedCaps[2] = 5366.542 * 3.412
        self.RatedCaps[3] = 6070.379 * 3.412
        self.RatedCaps[4] =  6112.913 * 3.412
        self.RatedSHR = 0.7

        self.MapRatedIndCap :float = 12000
        self.MapRatedODCap :float = 0.0
        for i in range(0,5,1):
           self.MapRatedODCap = self.MapRatedODCap +  self.RatedCaps[i]
           
        self.ZoneRatedIDCOP :float = 3.5
        
        MaxFanCFM :float = 0.37 * 2118.88 * 1.2 #allow overspeed 20%
        self.MaxCap = 6200.0 * 3.412
        
        self.RatedVas :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneTs :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneVas :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneMas :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneRHs :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneFanMas :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.SuperheatGrades :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneFANPOWs :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneTOTPOWs :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneTOTCAPs :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneSENCAPs :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneCOPs :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.ZoneMRs :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.Zonecurve_Qdot_fun_Twb_Toadbs :float = [0.0, 0.0, 0.0, 0.0, 0.0]
        self.Zonecurve_Qdot_fun_FlowFractions :float = [1.0, 1.0, 1.0, 1.0, 1.0]
        self.Zonecurve_EIR_fun_Twb_Toadbs :float = [1.0, 1.0, 1.0, 1.0, 1.0]
        self.Zonecurve_EIR_fun_FlowFractions :float = [1.0, 1.0, 1.0, 1.0, 1.0]
        self.Zonecurve_PLR_funs :float = [1.0, 1.0, 1.0, 1.0, 1.0]
        self.Coil_RunFractions :float = [1.0, 1.0, 1.0, 1.0, 1.0]
        
        for i in range(0,5,1):
            self.RatedVas[i] = self.RatedCaps[i]/self.MaxCap * MaxFanCFM
            
        self.ZoneT_handles :int = [-1, -1, -1, -1, -1]
        self.ZoneRH_handles :int = [-1, -1, -1, -1, -1]
        self.Fan_Massflow_handles :int = [-1, -1, -1, -1, -1]
        self.Coil_RunFrac_handles :int = [-1, -1, -1, -1, -1]
        
        self.Qdot_fun_Twb_Toadb_actuator_handles :int = [-1, -1, -1, -1, -1]
        self.EIR_fun_Twb_Toadb_actuator_handles :int = [-1, -1, -1, -1, -1]
        self.Qdot_fun_FlowFraction_actuator_handles :int = [-1, -1, -1, -1, -1]
        self.EIR_fun_FlowFraction_actuator_handles :int = [-1, -1, -1, -1, -1]
        self.PLR_actuator_handles :int = [-1, -1, -1, -1, -1]
        self.ZoneLoad_actuator_handles :int = [-1, -1, -1, -1, -1]
        #self.FanMassFlow_actuator_handles :int = [-1, -1, -1, -1, -1] #not used
        self.ZoneCoil_SHR_actuator_handles :int = [-1, -1, -1, -1, -1]
        
        #scale OD map to meet ID maps
        OAT = 95.0
        Tsat = 45.0
        SupH = 10.0
        SumCap = 0.0
        SumMr = 0.0
        for i in range(0,5,1):
            self.ZoneTs[i] = 80.0
            self.ZoneVas[i]= 400 * self.RatedCaps[i]/12000
            self.SuperheatGrades[i]=(SupH - 5)/((self.ZoneTs[i] - 1.0 - Tsat) - 5) * (5 - 1) + 1
            self.VRF_ID_Map.get_input_variables(cooling_cap_rated=self.RatedCaps[i], RelativeHum = 0.5, indoor_air_T = self.ZoneTs[i], \
                    Indoor_air_flow = self.ZoneVas[i], Evap_Temp=Tsat, Liq_Temp=OAT + 5.0, SuperH_Grad= self.SuperheatGrades[i])
            (self.ZoneFANPOWs[i], self.ZoneTOTCAPs[i], self.ZoneSENCAPs[i], self.ZoneMRs[i]) = self.VRF_ID_Map.get_output_variable()
            SumCap = SumCap + self.ZoneTOTCAPs[i]
            SumMr = SumMr + self.ZoneMRs[i]
        
        
        #scale the OD map by MapRatedODCap to match the total indoor capacity at a reasonal compressor RPM
        #in RPM is not reasonable, adjust the rated Mr in the OD map file
        #note: MapRatedODCap just refer to input combination to calculate the rated capacity, and scale the map; 
        #it doesn't have much to do with the total indoor capacity and real OD capacity at the given condition, which are resultant from the scaled map
        CapMax :float = self.MapRatedODCap * 1.5
        CapMin :float = self.MapRatedODCap * 0.5        
        Increment :int = 0
        while ((CapMax - CapMin) > 1000.0 and Increment < 20) :
            self.VRF_OD_Map.get_input_variables(cooling_cap_rated=self.MapRatedODCap, TotalMr = SumMr, Suction_Sat_T = Tsat, Ambient_T = OAT, \
                 SuperheatDegreeR=SupH)
            (OD_COMPPOW, OD_FANPOW, COMPRPM, OD_TOTCAP,OD_LIQT) = self.VRF_OD_Map.get_output_variable()
            
            if(OD_TOTCAP > SumCap):
                CapMax= self.MapRatedODCap
            else:
                CapMin= self.MapRatedODCap
            
            self.MapRatedODCap = (CapMax + CapMin)/2.0
            Increment +=1
            print(Increment, "----------------", self.MapRatedODCap, "----------------", SumMr )
            print("RPM=====", COMPRPM)
        
        #time.sleep(10)
        
        return 0
        
    def get_sensor_handles(self, state):
        self.OAT_sensor_handle = self.api.exchange.get_variable_handle(state,
                                        "Site Outdoor Air Drybulb Temperature", "Environment")

        print ('\n ###################', self.OAT_sensor_handle, '\n ####################')

        self.ZoneT_handles[0] = self.api.exchange.get_variable_handle(state,
                                        "Zone Mean Air Temperature", "Core_Zone")
        self.ZoneT_handles[1] = self.api.exchange.get_variable_handle(state,
                                        "Zone Mean Air Temperature", "Perimeter_Zone_1")
        self.ZoneT_handles[2] = self.api.exchange.get_variable_handle(state,
                                        "Zone Mean Air Temperature", "Perimeter_Zone_2")
        self.ZoneT_handles[3] = self.api.exchange.get_variable_handle(state,
                                        "Zone Mean Air Temperature", "Perimeter_Zone_3")
        self.ZoneT_handles[4] = self.api.exchange.get_variable_handle(state,
                                        "Zone Mean Air Temperature", "Perimeter_Zone_4")


        self.ZoneRH_handles[0] = self.api.exchange.get_variable_handle(state,
                                        "Zone Air Relative Humidity", "Core_Zone")
        self.ZoneRH_handles[1] = self.api.exchange.get_variable_handle(state,
                                        "Zone Air Relative Humidity", "Perimeter_Zone_1")
        self.ZoneRH_handles[2] = self.api.exchange.get_variable_handle(state,
                                        "Zone Air Relative Humidity", "Perimeter_Zone_2")
        self.ZoneRH_handles[3] = self.api.exchange.get_variable_handle(state,
                                        "Zone Air Relative Humidity", "Perimeter_Zone_3")
        self.ZoneRH_handles[4] = self.api.exchange.get_variable_handle(state,
                                        "Zone Air Relative Humidity", "Perimeter_Zone_4")
                                        

        self.Fan_Massflow_handles[0] =  self.api.exchange.get_variable_handle(state,
                                        "Fan Air Mass Flow Rate", "CORE_ZONE PSZ-AC-1 FAN")
        self.Fan_Massflow_handles[1] =  self.api.exchange.get_variable_handle(state,
                                        "Fan Air Mass Flow Rate", "PERIMETER_ZONE_1 PSZ-AC-2 FAN")
        self.Fan_Massflow_handles[2] =  self.api.exchange.get_variable_handle(state,
                                        "Fan Air Mass Flow Rate", "PERIMETER_ZONE_2 PSZ-AC-3 FAN")
        self.Fan_Massflow_handles[3] =  self.api.exchange.get_variable_handle(state,
                                        "Fan Air Mass Flow Rate", "PERIMETER_ZONE_3 PSZ-AC-4 FAN")
        self.Fan_Massflow_handles[4] =  self.api.exchange.get_variable_handle(state,
                                        "Fan Air Mass Flow Rate", "PERIMETER_ZONE_4 PSZ-AC-5 FAN")
                                        
        self.CLSetPointZone_sensor_handle =  self.api.exchange.get_variable_handle(state,
                                        "Zone Thermostat Cooling Setpoint Temperature", "CORE_ZONE")
                                        
        self.Coil_RunFrac_handles[0] =  self.api.exchange.get_variable_handle(state,
                                        "Cooling Coil Runtime Fraction", "CORE_ZONE PSZ-AC-1 1SPD DX HP CLG COIL 21KBTU/HR 13.0SEER")
               
        self.Coil_RunFrac_handles[1] =  self.api.exchange.get_variable_handle(state,
                                        "Cooling Coil Runtime Fraction", "Perimeter_Zone_1 PSZ-AC-2 1spd DX HP Clg Coil 21kBtu/hr 13.0SEER")
                          
        self.Coil_RunFrac_handles[2] =  self.api.exchange.get_variable_handle(state,
                                        "Cooling Coil Runtime Fraction", "Perimeter_Zone_2 PSZ-AC-3 1spd DX HP Clg Coil 18kBtu/hr 13.0SEER")
        
        self.Coil_RunFrac_handles[3] =  self.api.exchange.get_variable_handle(state,
                                        "Cooling Coil Runtime Fraction", "Perimeter_Zone_3 PSZ-AC-4 1spd DX HP Clg Coil 21kBtu/hr 13.0SEER")
                                        
        self.Coil_RunFrac_handles[4] =  self.api.exchange.get_variable_handle(state,
                                        "Cooling Coil Runtime Fraction", "Perimeter_Zone_4 PSZ-AC-5 1spd DX HP Clg Coil 21kBtu/hr 13.0SEER")
                                        
        print ('\n ###################', self.Coil_RunFrac_handles[4], '\n ####################')
        
        #time.sleep(10)     
                                        
        return 0
        
    def get_actuator_handles(self, state):
        ############## performance curve handles ##############                                                                                

        self.Qdot_fun_Twb_Toadb_actuator_handles[4] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFT 4')
        self.EIR_fun_Twb_Toadb_actuator_handles[4] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFT 4')  

        self.Qdot_fun_Twb_Toadb_actuator_handles[3] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFT 3')  

        self.EIR_fun_Twb_Toadb_actuator_handles[3] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFT 3')  

        self.Qdot_fun_Twb_Toadb_actuator_handles[2] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFT 2')  

        self.EIR_fun_Twb_Toadb_actuator_handles[2] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFT 2')  
                                    
        self.Qdot_fun_Twb_Toadb_actuator_handles[1] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFT 1')  
                                    
        self.EIR_fun_Twb_Toadb_actuator_handles[1] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFT 1')  

        self.Qdot_fun_Twb_Toadb_actuator_handles[0] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFT')  
                                    
                                    
        self.EIR_fun_Twb_Toadb_actuator_handles[0] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFT')   
                  
        
        self.Qdot_fun_FlowFraction_actuator_handles[4] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFFF 4') 
        self.EIR_fun_FlowFraction_actuator_handles[4] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFFF 4')   
                                                                 
        self.Qdot_fun_FlowFraction_actuator_handles[3] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFFF 3') 
        self.EIR_fun_FlowFraction_actuator_handles[3] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFFF 3')   
                                    
        self.Qdot_fun_FlowFraction_actuator_handles[2] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFFF 2') 
        self.EIR_fun_FlowFraction_actuator_handles[2] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFFF 2')   

        self.Qdot_fun_FlowFraction_actuator_handles[1] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFFF 1') 
        self.EIR_fun_FlowFraction_actuator_handles[1] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFFF 1')                               
        
        self.Qdot_fun_FlowFraction_actuator_handles[0] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLCAPFFF') 
        self.EIR_fun_FlowFraction_actuator_handles[0] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLEIRFFF')      
        
        self.PLR_actuator_handles[4] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLPLFFPLR 4')   
        self.PLR_actuator_handles[3] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLPLFFPLR 3')  
        self.PLR_actuator_handles[2] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLPLFFPLR 2')  
        self.PLR_actuator_handles[1] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLPLFFPLR 1')  
        
        self.PLR_actuator_handles[0] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='HPACCOOLPLFFPLR')    
        
        self.ZoneLoad_actuator_handles[0] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Unitary HVAC",
                                    control_type='Sensible Load Request',
                                    actuator_key='CORE_ZONE PSZ-AC-1 UNITARY HP') 
        
        self.ZoneLoad_actuator_handles[1] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Unitary HVAC",
                                    control_type='Sensible Load Request',
                                    actuator_key='PERIMETER_ZONE_1 PSZ-AC-2 UNITARY HP') 
        
        self.ZoneLoad_actuator_handles[2] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Unitary HVAC",
                                    control_type='Sensible Load Request',
                                    actuator_key='PERIMETER_ZONE_2 PSZ-AC-3 UNITARY HP') 
        
        self.ZoneLoad_actuator_handles[3] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Unitary HVAC",
                                    control_type='Sensible Load Request',
                                    actuator_key='PERIMETER_ZONE_3 PSZ-AC-4 UNITARY HP') 
        
        self.ZoneLoad_actuator_handles[4] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Unitary HVAC",
                                    control_type='Sensible Load Request',
                                    actuator_key='PERIMETER_ZONE_4 PSZ-AC-5 UNITARY HP') 
        
        #careful of below, directly specifying fan flow rate may cause humidity iteration issues
        # self.FanMassFlow_actuator_handles[0] = self.api.exchange.get_actuator_handle(state,
                                    # component_type= "Fan",
                                    # control_type='Fan Air Mass Flow Rate',
                                    # actuator_key='CORE_ZONE PSZ-AC-1 FAN') 
        
        # self.FanMassFlow_actuator_handles[1] = self.api.exchange.get_actuator_handle(state,
                                    # component_type= "Fan",
                                    # control_type='Fan Air Mass Flow Rate',
                                    # actuator_key='PERIMETER_ZONE_1 PSZ-AC-2 FAN')  
        
        # self.FanMassFlow_actuator_handles[2] = self.api.exchange.get_actuator_handle(state,
                                    # component_type= "Fan",
                                    # control_type='Fan Air Mass Flow Rate',
                                    # actuator_key='PERIMETER_ZONE_2 PSZ-AC-3 FAN')  
        
        # self.FanMassFlow_actuator_handles[3] = self.api.exchange.get_actuator_handle(state,
                                    # component_type= "Fan",
                                    # control_type='Fan Air Mass Flow Rate',
                                    # actuator_key='PERIMETER_ZONE_3 PSZ-AC-4 FAN') 
        
        # self.FanMassFlow_actuator_handles[4] = self.api.exchange.get_actuator_handle(state,
                                    # component_type= "Fan",
                                    # control_type='Fan Air Mass Flow Rate',
                                    # actuator_key='PERIMETER_ZONE_4 PSZ-AC-5 FAN') 
        
        self.ZoneCoil_SHR_actuator_handles[0] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='SHRCorrection0') 
        print(self.ZoneCoil_SHR_actuator_handles[0])
        
        self.ZoneCoil_SHR_actuator_handles[1] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='SHRCorrection1') 
        print(self.ZoneCoil_SHR_actuator_handles[1])
        
        self.ZoneCoil_SHR_actuator_handles[2] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='SHRCorrection2') 
         
        print(self.ZoneCoil_SHR_actuator_handles[2])
        
        self.ZoneCoil_SHR_actuator_handles[3] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='SHRCorrection3')         
        print(self.ZoneCoil_SHR_actuator_handles[3])
         
        self.ZoneCoil_SHR_actuator_handles[4] = self.api.exchange.get_actuator_handle(state,
                                    component_type= "Curve",
                                    control_type='Curve Result',
                                    actuator_key='SHRCorrection4')          
        print(self.ZoneCoil_SHR_actuator_handles[4])     
        
        #time.sleep(5)
        
        return 0
      
      
    #def on_after_predictor_before_hvac_managers(self, state) -> int:
    def on_begin_timestep_before_predictor(self, state) -> int:
        if self.api.exchange.api_data_fully_ready(state):
            if self.need_to_get_handles:
                self.get_sensor_handles(state)
                self.get_actuator_handles(state)
                self.need_to_get_handles = False
            
            # get some variables from building, whcih are input to HPDM
            # C to F
            OAT = self.api.exchange.get_variable_value(state, self.OAT_sensor_handle) * 1.8 +32
            LiqT = OAT + 5.0 
            
            if OAT < 60:
                return 0
                
            Tsat = 45
            SupH = 10
            OD_COMPPOW = 0.0
            OD_FANPOW = 0.0
            COMPRPM = 0.0
            OD_TOTCAP = 0.0
            OD_LIQT = 0.0
                        
            #specify large load that will have RunTimeFraction = 1.0, cooling load negative
            if OAT > 65:
                for i in range(0,5,1):
                    self.api.exchange.set_actuator_value(state, self.ZoneLoad_actuator_handles[i], -1e6 * self.MaxCap)
            else:
                for i in range(0,5,1):
                    self.api.exchange.set_actuator_value(state, self.ZoneLoad_actuator_handles[i], 0.0)
            
            StdDensity = 0.0765 * 0.000125998 #0.000125998 convert lb/hr to kg/s
            DeadBand = 3.0 #F
            SetPoint = self.api.exchange.get_variable_value(state, self.CLSetPointZone_sensor_handle) * 1.8 + 32
            print(SetPoint)
            #print ('Set Point ', SetPoint)
            #time.sleep(5)
                        
            TotalCapacity = 0.0
            SumMr = 0.0
            AirFRatio = 0.0
            for i in range(0,5,1):
                # C to F
                self.ZoneTs[i] = self.api.exchange.get_variable_value(state, self.ZoneT_handles[i])* 1.8 +32
                self.ZoneRHs[i] = self.api.exchange.get_variable_value(state, self.ZoneRH_handles[i])*0.01
                
                if self.ZoneTs[i] <= SetPoint:
                    self.ZoneVas[i] = 0.0
                elif self.ZoneTs[i] > SetPoint + DeadBand:
                    self.ZoneVas[i] = self.RatedVas[i]
                else:
                    self.ZoneVas[i] = self.RatedVas[i] * (self.ZoneTs[i] - SetPoint)/DeadBand 
                    if self.ZoneVas[i] < 0.5 *self.RatedVas[i]:
                       self.ZoneVas[i] = 0.5 *self.RatedVas[i]   

                if self.ZoneRHs[i] > 0.7: #turn on AC to dehumidify
                    self.ZoneVas[i] = 0.5 *self.RatedVas[i]  
                    
                self.ZoneMas[i] = self.ZoneVas[i]*StdDensity
                #note specify zone fan mass flow rate causing core zone have 100% relative humidity ??? don't know why
                ####self.api.exchange.set_actuator_value(state, self.FanMassFlow_actuator_handles[i], self.ZoneMas[i])
                   
                print("Zone--", i, "--Temp---", self.ZoneTs[i], "-", self.ZoneRHs[i], "Ambient temp ----------------", OAT) 
                
                if self.ZoneRHs[i] > 0.8: #limit the relative humidity, to avoid extropolation
                   self.ZoneRHs[i] = 0.8 
                   
                # MFR kg/s to lbs/hour
                self.ZoneFanMas[i]= self.api.exchange.get_variable_value(state, self.Fan_Massflow_handles[i]) *7936.64
                # grade from 1 to 5: ZoneT - 1.0, grade 1: 5R
                self.SuperheatGrades[i]=(SupH - 5)/((self.ZoneTs[i] - 1.0 - Tsat) - 5) * (5 - 1) + 1
                if self.SuperheatGrades[i] > 5:
                    self.SuperheatGrades[i] = 5
                elif self.SuperheatGrades[i] < 1:
                    self.SuperheatGrades[i] = 1
                
                if OAT > 65:
                    self.VRF_ID_Map.get_input_variables(cooling_cap_rated=self.RatedCaps[i], RelativeHum = self.ZoneRHs[i], indoor_air_T = self.ZoneTs[i], \
                    Indoor_air_flow = self.ZoneVas[i], Evap_Temp=Tsat, Liq_Temp=LiqT, SuperH_Grad= self.SuperheatGrades[i])
                
                #if (self.ZoneTs[i] <= SetPoint or OAT<=65):
                if self.ZoneVas[i] < 1e-10:
                    self.ZoneFANPOWs[i]=0
                    self.ZoneTOTCAPs[i]=0
                    self.ZoneSENCAPs[i]=0
                    self.ZoneMRs[i]=0
                    AirFRatio = 0.0
                else:
                    (self.ZoneFANPOWs[i], self.ZoneTOTCAPs[i], self.ZoneSENCAPs[i], self.ZoneMRs[i]) = self.VRF_ID_Map.get_output_variable()
                    AirFRatio = self.ZoneVas[i]/(self.ZoneTOTCAPs[i]/12000)                    
                    if self.ZoneTOTCAPs[i] <0.0 or self.ZoneSENCAPs[i] < 0.0 or self.ZoneMRs[i] < 0.0:
                        self.ZoneFANPOWs[i]=0
                        self.ZoneTOTCAPs[i]=0
                        self.ZoneSENCAPs[i]=0
                        self.ZoneMRs[i]=0
                        AirFRatio = 0.0
                    if self.ZoneFANPOWs[i] < 0.0:
                       self.ZoneFANPOWs[i]=0
                       
                self.Zonecurve_Qdot_fun_Twb_Toadbs[i] = self.ZoneTOTCAPs[i]/self.RatedCaps[i]
                
                print("Air flow ratio---------",AirFRatio, "        ", self.ZoneVas[i])
                self.api.exchange.set_actuator_value(state, self.Qdot_fun_Twb_Toadb_actuator_handles[i], self.Zonecurve_Qdot_fun_Twb_Toadbs[i] )
                TotalCapacity = TotalCapacity + self.ZoneTOTCAPs[i]
                SumMr = SumMr + self.ZoneMRs[i]
                self.api.exchange.set_actuator_value(state, self.Qdot_fun_FlowFraction_actuator_handles[i], self.Zonecurve_Qdot_fun_FlowFractions[i] )
                SHR = 1.0
                if self.ZoneTOTCAPs[i] > 0 :
                    SHR = self.ZoneSENCAPs[i]/self.ZoneTOTCAPs[i]
                    if SHR > 1.0: SHR = 1.0
                    self.api.exchange.set_actuator_value(state, self.ZoneCoil_SHR_actuator_handles[i], SHR/self.RatedSHR) 
                         
                print("Qratio ----------", self.Zonecurve_Qdot_fun_Twb_Toadbs[i])
                print("SHR ----------", SHR)
                                                
            #lower limit looking up from the OD map
            if OAT < 65:
                OAT = 65
            
            if SumMr > 1e-6:
                self.VRF_OD_Map.get_input_variables(cooling_cap_rated=self.MapRatedODCap, TotalMr = SumMr, Suction_Sat_T = Tsat, Ambient_T = OAT, \
                SuperheatDegreeR=SupH)
                (OD_COMPPOW, OD_FANPOW, COMPRPM, OD_TOTCAP,OD_LIQT) = self.VRF_OD_Map.get_output_variable()
                                
            if OD_COMPPOW < 0.0 or OD_FANPOW < 0.0 or OD_TOTCAP <0.0 or SumMr < 1e-6:
                OD_COMPPOW=0.0
                OD_FANPOW=0.0
                COMPRPM=0.0
                OD_TOTCAP=0.0
                OD_LIQT=LiqT
                #print(SumMr, "outdoor map", OAT)
                #time.sleep(5)
            
            OD_Power = OD_COMPPOW  + OD_FANPOW
            if OD_Power>0.0:
                OD_EER = OD_TOTCAP/OD_Power
            else:
                OD_EER = 0.0
            
            print("ODCOP-----------", OD_EER/3.412)
            
            for i in range(0,5,1):
                if self.ZoneTOTCAPs[i] > 0.0 and OD_EER > 0.0:
                    self.ZoneTOTPOWs[i] = self.ZoneTOTCAPs[i] /OD_EER + self.ZoneFANPOWs[i]
                else:
                    self.ZoneTOTPOWs[i] =0
                    
                if self.ZoneTOTPOWs[i] > 1e-10 :
                    self.ZoneCOPs[i]=self.ZoneTOTCAPs[i]/self.ZoneTOTPOWs[i]/3.412
                    print("Zone Capacity-----", self.ZoneTOTCAPs[i], "Zone COP-----", self.ZoneCOPs[i], "OD power-----", OD_COMPPOW)
                else:
                    self.ZoneCOPs[i]=1e-10       
                    
                self.Zonecurve_EIR_fun_Twb_Toadbs[i]=self.ZoneRatedIDCOP/self.ZoneCOPs[i]
                self.api.exchange.set_actuator_value(state, self.EIR_fun_Twb_Toadb_actuator_handles[i], self.Zonecurve_EIR_fun_Twb_Toadbs[i] )
                self.api.exchange.set_actuator_value(state, self.EIR_fun_FlowFraction_actuator_handles[i], self.Zonecurve_EIR_fun_FlowFractions[i] )
                self.api.exchange.set_actuator_value(state, self.PLR_actuator_handles[i], self.Zonecurve_PLR_funs[i] )
                print("EIRratio ----------", self.Zonecurve_EIR_fun_Twb_Toadbs[i])
            
         # double check, only self.Coil_RunFractions[i] = 1 or 0 is valid simulation            
            for i in range(0,5,1):
                if self.Coil_RunFrac_handles[i] >= 0:
                    self.Coil_RunFractions[i] = self.api.exchange.get_variable_value(state, self.Coil_RunFrac_handles[i])
                    print("RunTimeFraction ----------", self.Coil_RunFractions[i])
                    if self.Coil_RunFractions[i] > 0.0 and self.Coil_RunFractions[i] < 1.0:
                        time.sleep(500)
                
        return 0
 
